/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.base.rsf.requests.SdrHttpRequest;
import com.ibm.hwmca.base.rsf.requests.SdrHttpResponse;
import com.ibm.hwmca.base.rsf.requests.SdrRequestBody;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.rsf.RsfResult;
import com.ibm.hwmca.fw.rsf.RsfResultDetails;
import com.ibm.hwmca.fw.rsf.RsfResultProcessor;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.PIProblemDataConstants;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.sa.ServiceAgentAttr;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;
import com.ibm.hwmca.xfw.pa.util.ProblemDataDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ESARsfResultProcessor
implements RsfResultProcessor,
ServiceAgentAttr,
PIProblemDataConstants {
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private static final String CLASS_NAME = "[ESARsfResultProcessor] ";

    public void rsfRequestCompleted(RsfRequest request, RsfResult result) {
        SdrRequestBody sdrRB;
        ServiceAgentAttr.ESAsdrRequest sdrRequest;
        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] rsfRequestCompleted");
        String status = "ESA.status.success";
        LocalizableText statusDetails = result.getStatusMessage();
        String[] textmsg = null;
        String[] return_code = null;
        byte block = 3;
        Log theLog = new Log(-86, -45, 0, null, null, null, null, null);
        theLog.add((byte)3, request.getId());
        block = (byte)(block + 1);
        theLog.add(block, result);
        int statusCode = result.getStatusCode();
        if (statusCode == 1) {
            RsfResultDetails details = result.getDetails();
            if (details != null) {
                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] got details");
                ArrayList sdrResponses = (ArrayList)details.getAttribute("Sdr Responses");
                if (sdrResponses != null) {
                    Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] got sdrResponses " + sdrResponses.size());
                    textmsg = new String[sdrResponses.size()];
                    return_code = new String[sdrResponses.size()];
                    for (int i = 0; i < sdrResponses.size(); ++i) {
                        SdrHttpResponse httpResponse = (SdrHttpResponse)sdrResponses.get(i);
                        SdrHttpRequest httpRB = httpResponse.getRequest();
                        Trace.trace(TRACE_MASKF, CLASS_NAME + httpResponse.getHttpRc());
                        Trace.trace(TRACE_MASKF, CLASS_NAME + httpResponse.getHttpRcText());
                        Trace.trace(TRACE_MASKF, CLASS_NAME + httpResponse.getResponseRc());
                        Trace.trace(TRACE_MASKF, CLASS_NAME + httpResponse.getXmlRc());
                        Trace.trace(TRACE_MASKF, CLASS_NAME + httpResponse.getXmlResponse());
                        statusDetails = result.getReasonMessage();
                        String xmlResponse = httpResponse.getXmlResponse();
                        if (xmlResponse != null && xmlResponse.length() > 0) {
                            String request_id;
                            String reason_code;
                            block = (byte)(block + 1);
                            theLog.add(block, xmlResponse);
                            HashMap map = new HashMap();
                            ServiceAgentUtils.processSdrReturn(xmlResponse, map);
                            String return_text = (String)map.get("return-text");
                            if (return_text != null) {
                                textmsg[i] = return_text;
                            }
                            return_code[i] = (String)map.get("return-code");
                            if (return_code[i] != null) {
                                textmsg[i] = textmsg[i] + " " + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.returncode", new String[]{return_code[i]}).toString();
                            }
                            if ((reason_code = (String)map.get("reason-code")) != null) {
                                textmsg[i] = textmsg[i] + " " + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.reasoncode", new String[]{reason_code}).toString();
                            }
                            if ((request_id = (String)map.get("request-id")) != null) {
                                textmsg[i] = textmsg[i] + " " + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.reqid", new String[]{request_id}).toString();
                            }
                            Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] SDR textmsg: " + textmsg);
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] xmlResponse not set");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] sdrResponses was null");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] details was null");
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] StatusCode not OK: " + statusCode);
        }
        if (return_code != null) {
            for (int i = 0; i < return_code.length; ++i) {
                if (return_code[i].equals("100")) continue;
                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] return_code non_success: " + (String)return_code[i]);
                status = "ESA.status.failed";
                break;
            }
        } else {
            status = "ESA.status.failed";
        }
        if ((sdrRequest = (ServiceAgentAttr.ESAsdrRequest)(sdrRB = (SdrRequestBody)request.getBody()).getUserAttachment()) != null) {
            ServiceAgentAttr.ESAsdrFileInfo sdrFileInfo;
            String from;
            String failingmtms;
            String failingsystem;
            String problem;
            String pmh;
            block83: {
                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] requestType: " + sdrRequest.requestType);
                pmh = "";
                problem = "";
                failingsystem = "";
                failingmtms = "";
                from = "";
                NetworkInfo networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
                if (networkInfo != null && networkInfo.getComputerName().length() > 0 && networkInfo.getDomainName().length() > 0) {
                    from = from + networkInfo.getComputerName() + "." + networkInfo.getDomainName();
                }
                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] from: " + from);
                if (sdrRequest.problemUUID != null) {
                    Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] got problemUUID: " + sdrRequest.problemUUID);
                    try {
                        ProblemManager pm = ProblemManager.getProblemManager();
                        PIProblem theProblem = (PIProblem)pm.getProblem(sdrRequest.problemUUID);
                        if (theProblem == null) break block83;
                        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] got theProblem");
                        problem = String.valueOf(theProblem.getProblemNumber());
                        pmh = theProblem.getPMH();
                        if (theProblem.getReportingRemoteMachineSystem() != null && theProblem.getReportingRemoteMachineSystem().getMOSystemName() != null) {
                            failingsystem = theProblem.getReportingRemoteMachineSystem().getMOSystemName();
                        }
                        if (networkInfo != null && failingsystem.length() == 0) {
                            failingsystem = networkInfo.getComputerName();
                        }
                        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] failingsystem: " + failingsystem);
                        if (theProblem.getFailingSystem().getMTMS() != null) {
                            failingmtms = theProblem.getFailingSystem().getMTMS();
                        }
                        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] failingmtms: " + failingmtms);
                        theProblem.getProblemData().add("pdc_ESA_STATUS", new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", status));
                        theProblem.getProblemData().add("pdc_ESA_SDRSTATUS", statusDetails);
                        int rcCount = 0;
                        if (sdrRequest.sdrFiles != null) {
                            Iterator kk = sdrRequest.sdrFiles.entrySet().iterator();
                            while (kk.hasNext()) {
                                Map.Entry e = kk.next();
                                String fileKey = (String)e.getKey();
                                if (fileKey.equals("EED") && return_code != null && rcCount < return_code.length && return_code[rcCount].equals("100")) {
                                    sdrFileInfo = (ServiceAgentAttr.ESAsdrFileInfo)e.getValue();
                                    String fileLocation = sdrFileInfo.fileName;
                                    Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] working with fileLocation: " + fileLocation);
                                    List dList = theProblem.getProblemDataSet();
                                    if (dList != null) {
                                        for (int i = 0; i < dList.size(); ++i) {
                                            ProblemDataDescriptor dd = (ProblemDataDescriptor)dList.get(i);
                                            if (dd != null) {
                                                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] working with name: " + dd.getName());
                                                if (!fileLocation.endsWith(dd.getName())) continue;
                                                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] setCalledHome for: " + dd.getFileLocation());
                                                dd.setCalledHome(true);
                                                break;
                                            }
                                            Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] dd was null");
                                        }
                                    } else {
                                        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] dList was null");
                                    }
                                }
                                ++rcCount;
                            }
                        }
                        try {
                            pm.changed(theProblem);
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] pm.changed exception");
                            Trace.trace(TRACE_MASKF, e);
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] problem manager exception");
                        Trace.trace(TRACE_MASKF, e);
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] problemUUID not set");
                }
            }
            String subject = "";
            String message = "";
            LocalizableText eventMessage = null;
            if (sdrRequest.requestType.equals("Problem_EED")) {
                theLog.setEventName("SaEEDRes");
                subject = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.problem.subject").toString();
                if (status.equals("ESA.status.success")) {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.problem.success").toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.problem.success");
                } else {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.problem.failure").toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.problem.failure");
                }
            } else if (sdrRequest.requestType.equals("Authorization")) {
                theLog.setEventName("SaAuthRes");
                String authorizationID = sdrRequest.authorizationID;
                if (authorizationID == null || authorizationID.length() <= 0) {
                    authorizationID = " ";
                }
                subject = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.webauth.subject").toString();
                if (status.equals("ESA.status.success")) {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.webauth.success", new String[]{authorizationID}).toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.webauth.success", new String[]{authorizationID});
                } else {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.webauth.failure", new String[]{authorizationID}).toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.webauth.failure", new String[]{authorizationID});
                }
            } else if (sdrRequest.requestType.equals("Xmit_Immediate")) {
                theLog.setEventName("SaXmtImmRes");
                subject = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.immedxmit.subject").toString();
                if (status.equals("ESA.status.success")) {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.immedxmit.success").toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.immedxmit.success");
                } else {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.immedxmit.failure").toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.immedxmit.failure");
                }
            } else if (sdrRequest.requestType.equals("Xmit_Scheduled")) {
                theLog.setEventName("SaXmtSchRes");
                subject = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.schedxmit.subject").toString();
                if (status.equals("ESA.status.success")) {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.schedxmit.success").toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.schedxmit.success");
                } else {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.schedxmit.failure").toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.schedxmit.failure");
                }
            } else if (sdrRequest.requestType.equals("Xmit_VPD")) {
                theLog.setEventName("SaVPDRes");
                subject = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.endofcall.subject").toString();
                if (status.equals("ESA.status.success")) {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.endofcall.success").toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.endofcall.success");
                } else {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.endofcall.failure").toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.endofcall.failure");
                }
            } else if (sdrRequest.requestType.equals("Dump_EED")) {
                theLog.setEventName("SaEEDRes");
                subject = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.xmitdump.subject").toString();
                if (status.equals("ESA.status.success")) {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.xmitdump.success").toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.xmitdump.success");
                } else {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.xmitdump.failure").toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.xmitdump.failure");
                }
            } else if (sdrRequest.requestType.equals("Xmit_PM_Immediate")) {
                theLog.setEventName("SaAixPmResI");
                subject = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.xmitpmi.subject").toString();
                if (status.equals("ESA.status.success")) {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.xmitpmi.success").toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.xmitpmi.success");
                } else {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.xmitpmi.failure").toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.xmitpmi.failure");
                }
            } else if (sdrRequest.requestType.equals("Xmit_PM_Scheduled")) {
                theLog.setEventName("SaAixPmResS");
                subject = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.xmitpms.subject").toString();
                if (status.equals("ESA.status.success")) {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.xmitpms.success").toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.xmitpms.success");
                } else {
                    message = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.xmitpms.failure").toString();
                    eventMessage = new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.cem.xmitpms.failure");
                }
            } else {
                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] invalid requestType: " + sdrRequest.requestType);
            }
            String details = "";
            if (subject.length() > 0) {
                if (sdrRequest.sdrFiles != null) {
                    details = details + "\n";
                    Iterator i = sdrRequest.sdrFiles.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry e = i.next();
                        sdrFileInfo = (ServiceAgentAttr.ESAsdrFileInfo)e.getValue();
                        details = details + "\n" + (String)e.getKey() + ": " + sdrFileInfo.fileName;
                        if (sdrFileInfo.remove) {
                            Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] remove fileName: " + sdrFileInfo.fileName);
                            try {
                                File remFile = new File(sdrFileInfo.fileName);
                                if (remFile != null) {
                                    remFile.delete();
                                    continue;
                                }
                                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] remFile was null");
                            }
                            catch (Exception reme) {
                                Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] delete file exception");
                                Trace.trace(TRACE_MASKF, reme);
                            }
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] do not remove fileName: " + sdrFileInfo.fileName);
                    }
                    details = details + "\n";
                }
                if (failingsystem.length() > 0) {
                    details = details + "\n" + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.reportingsystem", new String[]{failingsystem}).toString();
                }
                if (failingmtms.length() > 0) {
                    details = details + "\n" + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.mtms", new String[]{failingmtms}).toString();
                }
                if (problem.length() > 0) {
                    details = details + "\n" + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.problemnumber", new String[]{problem}).toString();
                }
                if (pmh != null && pmh.length() > 0) {
                    details = details + "\n" + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.pmrnumber", new String[]{pmh}).toString();
                }
                details = details + "\n" + statusDetails.toString();
                if (textmsg != null) {
                    details = details + "\n" + new LocalizableText("com.ibm.hwmca.p.sa.res.SaMessages", "ESA.email.details").toString();
                    for (int i = 0; i < textmsg.length; ++i) {
                        details = details + "\n" + textmsg[i];
                    }
                }
                eventMessage.setSubst(new String[]{details.replaceAll("\n", " ")});
                SystemEventLog logEvent = new SystemEventLog(eventMessage, theLog.getEventName());
                logEvent.log();
                if (ServiceAgentUtils.getEmailSetting()) {
                    int rc = ServiceAgentUtils.ESASendEmailMsg("N", new LocalizableText(subject + " from " + from), new LocalizableText(message + details));
                } else {
                    Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] email not enabled");
                }
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ESARsfResultProcessor] sdrRequest not set");
        }
        theLog.log();
    }
}

